#include "particules.h"

#include "Physique.h"

#include <time.h>

#define PI 3.1415926535897932384626433832795

//initialisation du gnrateur de nbres aleatoires
inline void randomize(){
  srand((time_t) time(NULL));                           
}
//gnrateur de nbres alatoires entre 0 et n-1
inline int random(int n){
  return rand()%n;
}

CMoteurParticule::CMoteurParticule()
{
    nbPartsMax=0;
    tabPartz=NULL;
    nbParts=0;
    gravity=0.000097;
    randomize();
}

CMoteurParticule::~CMoteurParticule()
{
    clear();
}

void CMoteurParticule::initMoteurParticule(unsigned char nbPartsMax)
{
    if(this->nbPartsMax>0)clear();
    this->nbPartsMax=nbPartsMax;
    nbParts=0;
    tabPartz=new CAssPartParts[nbPartsMax];
    unsigned int i;
    for(i=0;i<nbPartsMax;i++)tabPartz[i].bob=NULL;
}

bool CMoteurParticule::addNewParticule(char *name,unsigned char colid_flags,float scale,float ffrot)
{
    if(nbParts>=nbPartsMax)return false;
    
    Cbob *bob=new Cbob;
    if(!bob->loadObj(name,scale))
    {
        delete bob;
        return false;
    }
    
    unsigned int idfd;
    if(!tabPartz[nbParts].bob)idfd=nbParts;
    else
    {
        for(idfd=0;idfd<nbPartsMax;idfd++)if(!tabPartz[idfd].bob)break;
    }
    
    tabPartz[idfd].ffrot=ffrot;
    
    tabPartz[idfd].colid_flags=colid_flags;
    tabPartz[idfd].bob=bob;
    
    nbParts++;
    
    return true;
}

bool CMoteurParticule::addNewParticule(char *name,GLuint texId,unsigned char colid_flags,float scale,float ffrot)
{
    if(nbParts>=nbPartsMax)return false;
    
    CbobTex *bob=new CbobTex;
    if(!bob->loadObj(name,texId,scale))
    {
        delete bob;
        return false;
    }
    
    unsigned int idfd;
    if(!tabPartz[nbParts].bob)idfd=nbParts;
    else
    {
        for(idfd=0;idfd<nbPartsMax;idfd++)if(!tabPartz[idfd].bob)break;
    }
    
    tabPartz[idfd].ffrot=ffrot;
    
    tabPartz[idfd].colid_flags=colid_flags;
    tabPartz[idfd].bob=bob;
    
    nbParts++;
    
    return true;
}

bool CMoteurParticule::addNewParticule(Cbob *bob,unsigned char colid_flags,float ffrot)
{
    if(nbParts>=nbPartsMax || !bob)return false;
    
    unsigned int idfd;
    if(!tabPartz[nbParts].bob)idfd=nbParts;
    else
    {
        for(idfd=0;idfd<nbPartsMax;idfd++)if(!tabPartz[idfd].bob)break;
    }
    
    tabPartz[idfd].ffrot=ffrot;
    
    tabPartz[idfd].colid_flags=colid_flags;
    tabPartz[idfd].bob=bob;
    
    nbParts++;
    
    return true;
}

bool CMoteurParticule::SuppTypeParticule(unsigned char partId)
{
    if(partId>=nbPartsMax || !tabPartz[partId].bob)return false;
    
    nbParts--;
    delete tabPartz[partId].bob;
    tabPartz[partId].bob=NULL;
    tabPartz[partId].prts.clear();
}

//Ajoute une particule de modle partId  la position pxyz vitesse vxyz avec une dure de vie de life ms
bool CMoteurParticule::addParticule(unsigned char partId,float px,float py,float pz,float vx,float vy,float vz,unsigned int life)
{
    if(partId>=nbPartsMax || !tabPartz[partId].bob)return false;
    
    SCommands res;
    res.prcs.px=px;res.prcs.py=py;res.prcs.pz=pz;
    res.prcs.vx=vx;res.prcs.vy=vy;res.prcs.vz=vz;
    res.prcs.life=life;
    res.partId=partId;
    
    //tabPartz[partId].prts.push_back(res);
    vCmd.push_back(res);
    
    return true;
}

//Le V tout seul signifi que seul la vitesse varie alatoirement
bool CMoteurParticule::addParticuleAleatV(unsigned char partId,float px,float py,float pz,float vx,float vy,float vz,unsigned int life,float amp)
{
    vx+=((((float)rand())/RAND_MAX)*2.0-1.0)*amp;
    vy+=((((float)rand())/RAND_MAX)*2.0-1.0)*amp;
    vz+=((((float)rand())/RAND_MAX)*2.0-1.0)*amp;
    srand((time_t) rand());
    
    return addParticule(partId,px,py,pz,vx,vy,vz,life);
}

//Le P tout seul signifi que seul la position varie alatoirement
bool CMoteurParticule::addParticuleAleatP(unsigned char partId,float px,float py,float pz,float vx,float vy,float vz,unsigned int life,float amp)
{
    px+=((((float)rand())/RAND_MAX)*2.0-1.0)*amp;
    py+=((((float)rand())/RAND_MAX)*2.0-1.0)*amp;
    pz+=((((float)rand())/RAND_MAX)*2.0-1.0)*amp;
    srand((time_t) rand());
    
    return addParticule(partId,px,py,pz,vx,vy,vz,life);
}

//PV veut dire avec une variation alatoire sur la position (d'amplitude ampP) et la vitesse (d'amplitude ampV)
bool CMoteurParticule::addParticuleAleatPV(unsigned char partId,float px,float py,float pz,float vx,float vy,float vz,unsigned int life,float ampP,float ampV)
{
    px+=((((float)rand())/RAND_MAX)*2.0-1.0)*ampP;
    py+=((((float)rand())/RAND_MAX)*2.0-1.0)*ampP;
    pz+=((((float)rand())/RAND_MAX)*2.0-1.0)*ampP;
    
    vx+=((((float)rand())/RAND_MAX)*2.0-1.0)*ampV;
    vy+=((((float)rand())/RAND_MAX)*2.0-1.0)*ampV;
    vz+=((((float)rand())/RAND_MAX)*2.0-1.0)*ampV;
    srand((time_t) rand());
    
    return addParticule(partId,px,py,pz,vx,vy,vz,life);
}

//Supprime juste les particules.
void CMoteurParticule::clearParts()
{
    unsigned int i;
    for(i=0;i<nbPartsMax;i++)tabPartz[i].prts.clear();
}

//Supprime les modles de particules et les particules galement.
void CMoteurParticule::clearPartType()
{
    unsigned int i;
    for(i=0;i<nbPartsMax;i++)
    {
        tabPartz[i].prts.clear();
        if(tabPartz[i].bob)
        {
            delete tabPartz[i].bob;
            tabPartz[i].bob=NULL;
        }
    }
    nbParts=0;
}

//Supprime tout
void CMoteurParticule::clear()
{
    clearPartType();
    nbPartsMax=0;
    delete []tabPartz;
    tabPartz=NULL;
}

void CMoteurParticule::setGravity(float gravity)
{
    this->gravity=gravity;
}

void CMoteurParticule::frameMoveThread(unsigned int elapsedTime)
{
    eTsv=elapsedTime;
    pthread_create(&frmMvThrd,NULL,frmMove,(void*)this);
}

void CMoteurParticule::frameMoveJoin()
{
    pthread_join(frmMvThrd,NULL);
    vector<SCommands>::iterator it,ed;
    
    ed=vCmd.end();
    for(it=vCmd.begin();it!=ed;it++)
    {
        tabPartz[it->partId].prts.push_back(it->prcs);
    }
    vCmd.clear();
}

#define myt ((CMoteurParticule*)data)
//Thread de MAJ
void *frmMove(void *data)
{
    myt->frameMove(myt->eTsv);
}

void CMoteurParticule::frameMove(unsigned int elapsedTime)
{
    unsigned int i;
    CAssPartParts *ptr=tabPartz;
    vector<Sprts>::iterator it,oldIt;
    float ffrot;
    for(i=0;i<nbPartsMax;i++)
    {
        if(ptr->bob)
        {
            it=ptr->prts.begin();
            ffrot=ptr->ffrot;
            while(it!=ptr->prts.end())
            {
                if(it->life>elapsedTime)
                {
                    it->life-=elapsedTime;
                    it->px+=it->vx*elapsedTime;
                    it->py+=it->vy*elapsedTime;
                    it->pz+=it->vz*elapsedTime;
                    forceFrotement(it->vx,ffrot,elapsedTime);
                    forceFrotement(it->vy,ffrot,elapsedTime);
                    forceFrotement(it->vz,ffrot,elapsedTime);
                    it->vy-=gravity*elapsedTime;
                    //oldIt=it;
                    it++;
                }
                else
                {
                    if(it==ptr->prts.begin())
                    {
                        ptr->prts.erase(it);
                        it=ptr->prts.begin();
                    }
                    else
                    {
                        ptr->prts.erase(it);
                    }
                }
            }
        }
        ptr++;
    }
}

void CMoteurParticule::render(float px)
{
    unsigned int i;
    CAssPartParts *ptr=tabPartz;
    vector<Sprts>::iterator it;
    for(i=0;i<nbPartsMax;i++)
    {
        if(ptr->bob)
        {
            //if((ptr->colid_flags)&(1<<1))glEnable(GL_LIGHTING);//light ?
            //else glDisable(GL_LIGHTING);
            if((ptr->colid_flags)&(1<<0))glEnable(GL_CULL_FACE);//cullface ?
            else glDisable(GL_CULL_FACE);
            
            if((ptr->colid_flags)&((1<<1)|(1<<2)))
            {
                glEnable(GL_BLEND);
                glDepthMask(GL_FALSE);
                if((ptr->colid_flags)&(1<<1))// BLENDSMOKE ?
                {
                    glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);//SMOKE
                }
                else if((ptr->colid_flags)&(1<<2))// BLENDLIGHT ?
                {
                    glBlendFunc(GL_SRC_ALPHA,GL_ONE);//LIGHT
                }
            }
            
            for(it=ptr->prts.begin();it!=ptr->prts.end();it++)
            {
                glPushMatrix();
                glTranslatef(it->px,it->py,(it->pz-=px));
                ptr->bob->draw();
                glPopMatrix();
            }
            
            if((ptr->colid_flags)&((1<<1)|(1<<2))){glDepthMask(GL_TRUE);glDisable(GL_BLEND);}
        }
        ptr++;
    }
}
